<%--
 This is the HMC Login page.  It is presented to the user when they try to
 access a protected resource.  We could have used the WCL library to produce
 this page, but since it's very simple, we choose not too.  However, in order
 to make the page look like a WCL page, we reference their style sheet and
 include <span> tags and "class" attributes that mimic their pages.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.login.res.login">
<html>
<head>
   <hmc:title><fmt:message key="title"/></hmc:title>
   <link href="/wclres/WclBaseSkinCSS.css" rel="stylesheet" type="text/css"/>
   <link rel="SHORTCUT ICON" href="/favicon.ico"/>
   <link rel="icon" href="/hmc.png" type="image/png"/>
</head>
<body onload="window.document.LoginForm.j_username.focus();">
<span class="wclContainer">
<h1><fmt:message key="title"/></h1>
<p><fmt:message key="introduction"/></p>

<c:if test="${!empty errorPage}">
<p>
<font color="red">
<fmt:message key="loginErrorMessage"/>
</font>
</p>
</c:if>

<form name="LoginForm" method="POST" action="j_security_check" >
 <table>
  <tr>
   <td><fmt:message key="useridLabel"/>:</td>
   <td><input type="text" class="wclTextEntry" name="j_username" maxlength="32"></td>
  </tr>
  <tr>
   <td><fmt:message key="passwordLabel"/>:</td>
   <td><input type="password" class="wclTextEntry" name="j_password"></td>
  </tr>
 </table>
 <p>
 <input type="submit" value="<fmt:message key='loginButtonLabel'/>" name="j_security_check"
        class="wclButton" onmouseout="className='wclButton'"
        onmouseover="className='wclButtonMouseOver'" />
 <hmc:helpButton book="base" topic="com/ibm/hwmca/base/logon/res/LogonRes/HMCLogonPanel"/>
 </p>
</form>
</span>
</body>
</html>
</fmt:bundle>
